#include <algorithm>
#include <iostream>
#include <utility>

using namespace std;

struct sorted_v {
	unsigned index;
	unsigned value;
	bool operator<(sorted_v r) { return value < r.value; }
};

void solv(sorted_v p[], unsigned np) {
	unsigned l = 1 << (int)ceil(log2(np));
	unsigned rmd = l - np;
	for (unsigned i = rmd; i < np - (i - rmd) - 1; i++) {
		swap(p[i].index, p[np - (i-rmd) - 1].index);
	}
	if(rmd>1) solv(p, rmd);
}

int main() {
	unsigned t;
	cin >> t;
	for (unsigned i = 0; i < t; i++) {
		unsigned n;
		cin >> n;
		auto p = new sorted_v[n+1];
		for (unsigned j = 0; j < n + 1; j++) { p[j].index = j; cin >> p[j].value; }
		sort(p, p + n + 1);
		cout << n * (n + 1) << endl;
		solv(p, n + 1);
		auto q = new unsigned[n + 1];
		for (unsigned j = 0; j < n + 1; j++) { q[p[j].index] = p[j].value; }
		delete[] p;
		for (unsigned j = 0; j < n + 1; j++) { cout << q[j] << ' '; }
		delete[] q;
		cout << endl;
	}
	return 0;
}